import { ActionFormData } from '@minecraft/server-ui';
import { world } from '@minecraft/server';

const ui = new ActionFormData()
  .title("§l§4Vanilla Enchantment")
  .body("§l§6Minimum 25 Level Required") 
  .button("§l§5Sharpness V", "textures/items/book_enchanted")
  .button("§l§5Looting III", "textures/items/book_enchanted")
  .button("§l§5Unbreaking III", "textures/items/book_enchanted")
  .button("§l§5Protection IV", "textures/items/book_enchanted")
.button("§l§5Depth Strider III", "textures/items/book_enchanted")
.button("§l§5Feather Falling IV", "textures/items/book_enchanted")
.button("§l§5Frost Walker II", "textures/items/book_enchanted")
.button("§l§5Respiration III", "textures/items/book_enchanted")
.button("§l§5Soul Speed III", "textures/items/book_enchanted")
.button("§l§5Thorns III", "textures/items/book_enchanted")
  .button("§l§5Swift Sneak III", "textures/items/book_enchanted")
  .button("§l§5Efficiency V", "textures/items/book_enchanted")
  .button("§l§5Fire Aspect II", "textures/items/book_enchanted")
  .button("§l§5Infinity I", "textures/items/book_enchanted")
  .button("§l§5Silk Touch", "textures/items/book_enchanted")
  .button("§l§5Fortune III", "textures/items/book_enchanted")
  .button("§l§5Mending", "textures/items/book_enchanted")
  .button("§l§5Wind Burst III", "textures/items/book_enchanted");

world.beforeEvents.worldInitialize.subscribe(initEvent => {
  initEvent.blockComponentRegistry.registerCustomComponent('zc_aetb:trigger', {
  	onPlayerDestroy: e => { e.player.runCommand("effect @e[type=zc:advance_enchantment_book] invisibility 30 3 true"); 
e.player.runCommand("tp @e[type=zc:advance_enchantment_book,r=2] ~~-4~"); 
e.player.runCommand("kill @e[type=zc:advance_enchantment_book,r=5]");},
    onPlayerInteract: e => {
      ui.show(e.player).then(response => {
        if (response.canceled) {
          e.player.runCommandAsync(``);
        } else {
          switch (response.selection) {
            case 0:
              e.player.runCommandAsync(`enchant @s[lm=25] sharpness 5`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
            case 1:
              e.player.runCommandAsync(`enchant @s[lm=25] looting 3`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
            case 2:
              e.player.runCommandAsync(`enchant @s[lm=25] unbreaking 3`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
            case 3:
              e.player.runCommandAsync(`enchant @s[lm=25] protection 4`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
              case 4:
              e.player.runCommandAsync(`enchant @s[lm=25] depth_strider 3`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
              case 5:
              e.player.runCommandAsync(`enchant @s[lm=25] feather_falling 4`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
              case 6:
              e.player.runCommandAsync(`enchant @s[lm=25] frost_walker 2`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
              case 7:
              e.player.runCommandAsync(`enchant @s[lm=25] respiration 3`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
              case 8:
              e.player.runCommandAsync(`enchant @s[lm=25] soul_speed 3`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
              case 9:
              e.player.runCommandAsync(`enchant @s[lm=25] thorns 3`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
              case 10:
              e.player.runCommandAsync(`enchant @s[lm=25] swift_sneak 3`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
              case 11:
              e.player.runCommandAsync(`enchant @s[lm=25] efficiency 5`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
              case 12:
              e.player.runCommandAsync(`enchant @s[lm=25] fire_aspect 2`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
              case 13:
              e.player.runCommandAsync(`enchant @s[lm=25] infinity`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
              case 14:
              e.player.runCommandAsync(`enchant @s[lm=25] silk_touch`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
              case 15:
              e.player.runCommandAsync(`enchant @s[lm=25] fortune 3`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
              case 16:
              e.player.runCommandAsync(`enchant @s[lm=25] mending`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
              case 17:
              e.player.runCommandAsync(`enchant @s[lm=25] wind_burst 3`);
              e.player.runCommandAsync(`xp -2l @s[lm=25]`);
              break;
          }
        }
      });
    },
  });
});
